
#Include Once "./Core/Code/Gfx Manip/Gfx Manip.bas"

Declare Sub Gfx_Buffer_Shift ( Source As FB.Image Ptr, ByRef Dest As FB.Image Ptr, X As Long = 0, Y As Long = 0 )

Sub Gfx_Buffer_Shift ( Source As FB.Image Ptr, ByRef Dest As FB.Image Ptr, X As Long = 0, Y As Long = 0 )
	
	Dim As Long pX = 0, pY = 0
	
	Dim As FB.Image Ptr Intermediary, IntermediaryX, IntermediaryY
	
	If Dest <> 0 Then
		ImageDestroy ( Dest )
	End If
	
	Dest = ImageCreate ( Source - > Width, Source - > Height, RGBA ( 0, 0, 0, 0 ), 32 )
	
	Intermediary = ImageCreate ( Source - > Width, Source - > Height, RGBA ( 0, 0, 0, 0 ), 32 )
	
	Put Intermediary, ( 0, 0 ), Source, PSet
	
	If X Mod Source - > Width <> 0 Then
		
		IntermediaryX = ImageCreate ( Source - > Width, Source - > Height, RGBA ( 0, 0, 0, 0 ), 32 )
	
		For pX = 0 to Source - > Width - 1 Step 1
		
			Put IntermediaryX, ( ( pX + X ) Mod Source - > Width, 0 ), Intermediary, ( pX, 0 ) - ( pX, Source - > Height - 1 ), PSet
		
		Next pX
		
		Put Intermediary, ( 0, 0 ), IntermediaryX, PSet

		ImageDestroy ( IntermediaryX )
	
	End If

	If Y Mod Source - > Height <> 0 Then
		
		IntermediaryY = ImageCreate ( Source - > Width, Source - > Height, RGBA ( 0, 0, 0, 0 ), 32 )
	
		For pY = 0 to Source - > Height - 1 Step 1
		
			Put IntermediaryY, ( 0, ( pY + Y ) Mod Source - > Height ), Intermediary, ( 0, pY ) - ( Source - > Width - 1, pY ), PSet
		
		Next pY
				
		Put Intermediary, ( 0, 0 ), IntermediaryY, PSet

		ImageDestroy ( IntermediaryY )
	
	End If
	
	Put Dest, ( 0, 0 ), Intermediary, PSet
	
	ImageDestroy ( Intermediary )

End Sub